cd "Z:\work\Baze\SILC_Serbia\2019"

**********************************
** extract individual vars *******
**********************************
use p-file, clear
merge 1:1 idperson using r-file
preserve
keep idhh idperson weight 
save weight_ind, replace
restore

* generate adult equivalent index
bysort idhh: egen nadults=sum(age>=14)
bysort idhh: egen nchildren=sum(age<14)
gen adulteq=1+0.5*(nadults-1) + 0.3*(nchildren)
bysort idhh: egen hsize=sum(age>=0)
la var adulteq "Adult equivalent"
la var hsize "Household size"

* income from employemnt
clonevar yee_n = py010n
clonevar yee_car_n = py021n
clonevar yse_n = py050n

clonevar yee_g = py010g
clonevar yee_car_g = py021g
clonevar yse_g = py050g

* individual benefits and pensions
clonevar ppr_n = py080n
clonevar bun_n = py090n
clonevar poa_n = py100n
clonevar psu_n = py110n
clonevar bsi_n = py120n
clonevar bdi_n = py130n
clonevar bed_n = py140n

* agregate on the household level
foreach var in yee_n yee_car_n yse_n ppr_n bun_n poa_n psu_n bsi_n bdi_n bed_n {
clonevar `var'_hh = `var'
bys idhh: egen `var'_hh1 = sum(`var')
replace `var'_hh = `var'_hh1
drop `var'_hh1
}

* keep necessary variables
keep idhh adulteq hsize yee_n_hh - bed_n_hh
duplicates drop idhh, force
sum
save p-file_hh, replace

**********************************
** househod vars *****************
** merged with individual vars ***
**********************************

use h-file, clear
merge 1:1 idhh using p-file_hh
drop _merge
merge 1:1 idhh using dif_hh
drop _merge

* correct pensions varialbes for dif
* (see 01b do file)
replace poa_n_hh = poa_n_hh + dif
drop dif

* income from rent, captial and youth income
clonevar yre_n = hy040n
clonevar yca_n = hy090n
clonevar yyo_n = hy110n

* household level benefits
clonevar bca_n = hy050n
clonevar bsa_n = hy060n
clonevar bho_n = hy070n

* cash transfers received and paid
clonevar ctr_n = hy080n
clonevar ctp_n = hy130n

* tax on wealth (missing in 2019 data)
clonevar twe = hy120g

egen i_n = rowtotal (yee_n_hh yee_car_n_hh ///
					 yse_n_hh yre_n yca_n ///
					 yyo_n)
label var i_n "Total income from labour/capital"
egen p_n = rowtotal (ppr_n_hh poa_n_hh psu_n_hh)
label var p_n "Total pensions"
egen b_n = rowtotal (bun_n_hh bsi_n_hh bdi_n_hh ///
				     bed_n_hh bca_n bsa_n bho_n)
label var b_n "Total benefits"
gen c_n = ctr_n - ctp_n
label var c_n "Net transfers"

sum i_n p_n b_n c_n

egen dispy = rowtotal (i_n p_n b_n c_n)
sum dispy hy020
la var dispy "Total household disposable income"

gen dif = dispy - hy020
recode dif (-0.9999 / 0.9999 = 0)
replace dif = int(dif)
ta dif
drop dif 

keep idhh adulteq hsize yee_n_hh-dispy
save data1_hh, replace

merge 1:m idhh using weight_ind

* caclulate income per adult equivalent
gen income_ae = dispy/adulteq

* calculate poverty line
sum income_ae [aw=weight] , d
gen povline =r(p50)*0.60
sum povline

* poverty indicator
gen pov60 = income_ae<povline

* poverty rate
ta pov60 [iw=weight]






